/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package salesApplication;

import java.util.Optional;
import products.Pen;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestOptionalClass {
    
    public static void printPen(Pen p){
        //Print the name of the Pen
//        System.out.println("Name of new pen: "+p.getName());
        
        //Check for null first...
//        if (p != null) {
//            System.out.println("Name of new pen: "+p.getName());
//        } else {
//            System.out.println("Pen does not exist!");
//        }
        
        //Using an Optional class 
//        Optional<Pen> penOptional = Optional.ofNullable(p);      
//        if (penOptional.isPresent()) {
//            System.out.println("Name of new pen: "+penOptional.get().getName());
//        } else {
//            System.out.println("Pen does not exist!");
//        }  
//        penOptional.ifPresent(pen -> System.out.println("Name of new pen: "+pen.getName()));  
        //Alternative: use optional to give a default value of one doesn't already exist.        
//        Pen pOrDefault = Optional.ofNullable(p).orElse(new Pen("Default Pen."));  
//        System.out.println("Name of new pen: "+pOrDefault.getName()); 
    }
    
    public static void main(String[] args) {
        //Create a pen and print out it's name
        Pen myPen = new Pen("My Pen");
        printPen(myPen);
        //Create another pen (with no content)
        //and print out it's name (which doesn't exist)
        Pen noPen=null;
        printPen(noPen);
    }
}
